/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.provider.rs6k.AsynchEventQueueMgr;
import com.ibm.hsc.common.util.HSCLogUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import org.snia.wbem.cim.CIMException;
import org.snia.wbemcfg.GlobalConfig;

public class CspListener
extends Thread {
    private AsynchEventQueueMgr mEvtMgr;
    private String mCecName = null;
    private Socket mAsynchSock = null;
    private DataInputStream mAsynchInStream = null;
    private boolean mClose = false;
    private final int mPort = 9734;
    private boolean mConnectionFlag = false;

    public CspListener(String string, AsynchEventQueueMgr asynchEventQueueMgr) throws CIMException {
        this.mEvtMgr = asynchEventQueueMgr;
        this.mCecName = string;
        this.initialize();
    }

    public void initialize() throws CIMException {
        if (this.mConnectionFlag) {
            System.out.println("CspListener no need to initialize connection for " + this.mCecName);
            return;
        }
        System.out.println("CspListener initializing connection for " + this.mCecName);
        boolean bl = false;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string = inetAddress.getHostName();
            this.mAsynchSock = new Socket(string, 9734);
            this.mAsynchSock.setSoTimeout(2000);
            this.mAsynchInStream = new DataInputStream(this.mAsynchSock.getInputStream());
            int n = this.mCecName.length();
            byte[] byArray = new byte[n + 4];
            byte[] byArray2 = this.mCecName.getBytes();
            byArray[0] = -1;
            byArray[1] = 3;
            byArray[2] = (byte)(n + 1 & 0xFF);
            int n2 = 0;
            while (n2 < n) {
                byArray[n2 + 3] = byArray2[n2];
                ++n2;
            }
            byArray[n + 3] = 0;
            DataOutputStream dataOutputStream = new DataOutputStream(this.mAsynchSock.getOutputStream());
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.flush();
            byte[] byArray3 = new byte[2];
            this.mAsynchInStream.readFully(byArray3);
            int n3 = ~(byArray3[0] << 8 | byArray3[1] & 0xFF) + 1;
            if (n3 > 1) {
                byte[] byArray4 = new byte[n3];
                this.mAsynchInStream.readFully(byArray4);
                String string2 = new String(byArray4, 0, n3 - 1);
                if (!string2.equals(this.mCecName)) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
            bl = true;
        }
        if (bl) {
            this.cleanUp();
            throw new CIMException("138B");
        }
        this.mConnectionFlag = true;
        System.out.println("CspListener initializing successfully for " + this.mCecName);
    }

    public void run() {
        int n = 0;
        byte[] byArray = null;
        System.out.println("starts CspListener for " + this.mCecName);
        while (!this.mClose) {
            try {
                n = this.mAsynchInStream.readUnsignedShort();
                if (this.mClose) break;
                byArray = new byte[n];
                this.mAsynchInStream.readFully(byArray);
                System.out.print("     received packet:[");
                int n2 = 0;
                while (n2 < n) {
                    System.out.print(byArray[n2] + ",");
                    ++n2;
                }
                System.out.println("] total bytes: " + n);
                this.mConnectionFlag = true;
                this.mEvtMgr.queueEventPacket(byArray);
            }
            catch (InterruptedIOException interruptedIOException) {
                this.mConnectionFlag = false;
            }
            catch (Throwable throwable) {
                this.mConnectionFlag = false;
                if (GlobalConfig.debugLevel((int)6) > 0) {
                    throwable.printStackTrace();
                }
                if (this.mClose) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }
        this.cleanUp();
        System.out.println("the CspListener for " + this.mCecName + " is exiting.");
    }

    public void close() {
        block2: {
            System.out.println("close CspListener thread. CEC=" + this.mCecName);
            this.mClose = true;
            try {
                this.interrupt();
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block2;
                throwable.printStackTrace();
            }
        }
    }

    private void cleanUp() {
        block9: {
            block8: {
                try {
                    if (this.mAsynchInStream != null) {
                        this.mAsynchInStream.close();
                        if (GlobalConfig.debugLevel((int)6) > 0) {
                            System.out.println("     Closing event InputStream for " + this.mCecName + ". _asynchInStream:" + this.mAsynchInStream);
                        }
                    }
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                    if (GlobalConfig.debugLevel((int)6) <= 0) break block8;
                    throwable.printStackTrace();
                }
            }
            try {
                if (this.mAsynchSock != null) {
                    this.mAsynchSock.close();
                    if (GlobalConfig.debugLevel((int)6) > 0) {
                        System.out.println("     Closing event socket for " + this.mCecName + ". Socket:" + this.mAsynchSock);
                        System.out.println("     current Thread is " + Thread.currentThread());
                    }
                }
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._AsyncEventClassLogInfo);
                if (GlobalConfig.debugLevel((int)6) <= 0) break block9;
                throwable.printStackTrace();
            }
        }
        this.mAsynchInStream = null;
        this.mAsynchSock = null;
    }
}

